#!/usr/bin/env python3
# wrtten by T. Nakamura, KEK, 2024-03-27, 2019-03-17
#################
### example of input python file
#################
#--BEGIN input file --
# ntap
# coef1  tap1   
# coef2  tap2   
# ... 
#--END  input file --
##################################


import sys, math, cmath, random, re, os, os.path; from math import *; from cmath import *  
import numpy as np 
import importlib

np.set_printoptions(suppress=True)
# np.set_printoptions(precision=10)
np.set_printoptions(formatter={'float':'{: .6g}'.format})

argvs = sys.argv
argc  = len( argvs ) 
# print("# argc  = ", argc )
# print("# argvs = ", argvs )
if not ( 2 <= argc <= 3 ) :
   print(" usage : ", argvs[0],  "FIR_filter_file  <target tune>")
   print("   this calculate FIR filter tune response" )  
   print("     Set target tune for second argumant if the effective gain is necessary")
   print("        effective gain(nu) = gain(nu) * cos( phase(nu) - phase(nu0)" )
   print("        where nu0 is target tune") 
   print("    FIR_filter_file :")
   print("     number_of_taps") 
   print("     coef1  turn1") 
   print("     coef2  turn2") 
   print("     coef3  turn3") 
   print("     ... ") 
 
   quit()

filename = argvs[1]
if argc == 3:
   nu0 = float( argvs[2] )
else:
   nu0 = -1

def main( filename, nu0 ) :
    with open(filename) as fin:
         coefL, turnL, _ = get_data_from_file( fin ) 
    gain0L, phase0L, gain0_effL, nu_axisL = FIR_resp_turn( coefL, turnL, nu0 )
    if 0 < nu0: 
       print("# nu   gain   phase   gain_eff")
       for i in range( len(nu_axisL) ):
           print(nu_axisL[i], gain0L[i], phase0L[i], gain0_effL[i] )
    else:
       print("# nu   gain   phase")
       for i in range( len(nu_axisL) ):
           print(nu_axisL[i], gain0L[i], phase0L[i])


def get_data_from_file( file ) :
    xl, yl, cl = [],[],[]
    for line in file :
        sl = line.strip()
        if not sl.startswith("#"):
           argvs =  sl.split() 
           if 2 <= len(argvs) :
              xl.append( float( argvs[0] ) )
              yl.append( float( argvs[1] ) )
        else:
           cl.append( line )
           print("#C:",line,end="")
    file.close()
    xL, yL = np.array(xl,dtype='float'), np.array(yl,dtype='float')
    return xL, yL, cl

def FIR_resp_turn( coefL, turnL, nu0 ):
    ntap = len( turnL ) 
    dnu_axis = 0.02 * 1/max(turnL) 
    nnu_axis = int(1/dnu_axis+0.5)+1
    print( "#FIR_resp  dnu_axis = ", dnu_axis )
    for i in range( len(turnL) ):
         print( "#INPUT  coef[%d] turn[%d] = %10.6f %10.6f" %(i, i, coefL[i],turnL[i]) )
    gain0L     = np.zeros(nnu_axis,dtype=float)
    phase0L    = np.zeros(nnu_axis,dtype=float)
    gain0_effL = np.zeros(nnu_axis,dtype=float)
    nu_m = nu0
    if 0 <= nu_m : 
       rr_nu_m = 0.0
       for j in range( ntap ) :
           rr_nu_m  = rr_nu_m + coefL[j] * np.exp( -1j * 2*pi*  nu_m *turnL[j] )  
           gain_nu_m  = np.absolute( rr_nu_m )
           phase_nu_m = np.angle( rr_nu_m )
       nu_axisL = np.linspace( int(nu_m), int(nu_m)+1, nnu_axis )
    else:
       nu_axisL = np.linspace( 0.0, 1.0, nnu_axis ) 
       phase_nu_m = 0.0
    for i in range(nnu_axis): 
        nu_i = nu_axisL[i]
        rr_0 = 0
        for j in range( ntap ) :
            rr_0      = rr_0      + coefL[j] * np.exp( -1j * 2*pi*  nu_i *turnL[j] )
        gain0L[i]     = np.absolute( rr_0 )
        phase0L[i]    = np.angle( rr_0 )
        gain0_effL[i] = gain0L[i] * np.cos( phase0L[i] - phase_nu_m )
    return gain0L, phase0L, gain0_effL, nu_axisL

if __name__ == '__main__' :
    main( filename, nu0 )

exit()



