#!/usr/bin/env python3
# wrtten by T. Nakamura, KEK, 2024-Apr-17,2024-Apr-10,2024-03-27, 2019-03-17
#################
### example of input python file
#################
###  sample input file
####     G : gain, P: phase, nu:tune
###--- type1 : same as in previous version 
# turnL = [ 1,2,3,4,5,6,7,8,9,10,11,12 ] # previous turn number of input (this case, 1 to 12-th previous turns are input )
# tune0 = {"nu":0,    "gain":0,              "order":0 } # constraint : dG/dnu = 0  
# tune1 = {"nu":0.15, "gain":1, "phase":-90, "order":2 } # constraint : dG/dnu=d^2 G/dnu^2=0 and dP/dnu=d^2P/dnu^2=0  
# tuneL = [ tune0, tune1 ]                               # list of tune data
###--- examples of definition of tune parameters
# tune1 = {"nu":0.15,"gain":1,"phase":-90,"order_phase":2,"order_gain":0 }    # dP/dnu = d^2P/dnu^2 = 0, no constraint for dG/dnu, dG^2/dnu^2, ... 
# tune1 = {"nu":0.15,"gain":1,"phase":-90,"order_phase":2,"order_gain":[2] }  # dP/dnu = d^2P/dnu^2 = 0, d^2G/dnu^2 = 0, no constraint for dG/dnu
# and, following three are the same input parameters with constraint : dG/dnu=d^2 G/dnu^2=0 and dP/dnu=d^2P/dnu^2=0
#   for backward compatibility
# tune1 = {"nu":0.15, "gain":1, "phase":-90, "order_phase":2, "order_gain":[1,2]} 
# tune1 = {"nu":0.15, "gain":1, "phase":-90, "order_phase":2, "order_gain":2 }    
# tune1 = {"nu":0.15, "gain":1, "phase":-90, "order":2 }                          
#  and one may use "zeta" or "psi" instead of "phase", also for backward compatibility.
#  
#################
# parameters of each dictionary are
#  "nu"     : target tune
#  "gain"   : gain at target tune 
#  "phase"  : phase at target tune in degree 
#  "order_phase", "order" : order of Tylor expansion for tune shift around target tune for phase response
#  "order_gain",  "order" : order of Tylor expansion for tune shift around target tune for gain response 
# for "order, " 
#   "order":0 , just a band pass filter 
#          :1 , flat region around target tune 
#          :2 , wider flat region around target tune 
#            ...
#  for nu=0, no phase constraint is necessary 
##################################

import sys, os
from math import *
import numpy as np 
# import numbers

argvs = sys.argv
argc  = len( argvs ) - 1
if argc != 1  :
   print(" usage: "+ os.path.basename(argvs[0]) + "   input_python_file")  
#   print(" usage : ", argvs[0],  "   input_python_file" )
   quit()
filename = argvs[1]

# including input python file
exec(compile(source=open(filename).read(), filename=filename, mode='exec'))

def main( filename ):
    calc_FIR( tuneL, turnL )

def calc_FIR( tuneL, turnL ) : #  be careful, tuNEL and  tuRNL
    print( "# turnL = ", turnL )
    for tune in tuneL : 
        print( "# tune = ", tune )
    ntap = len( turnL )
#
# --- get parameters ---
#
    nuL, gainL, psiL, order_phaseLL, order_gainLL = dict2data( tuneL )
#
# --- check constraints and taas
#
    nconstr0 = 0
    nconstrN = 0
    for i in range(len(nuL)):
        if nuL[i] == 0 :
           nconstr0 = nconstr0 + len( order_gainLL[i] ) # [ 0 ( ,1,2,.. ) ]
        if nuL[i] != 0 :
           nconstrN = nconstrN + len( order_gainLL[i] ) + len( order_phaseLL[i] )
    nconstr = nconstr0 + nconstrN
    print("# ntap  :  nconstr  nconstr0  nconstN  = ", ntap, " : ", nconstr, nconstr0, nconstrN )
    if len(turnL) < nconstr :
        print("ERROR: number of taps < anumber of constraints") 
        quit()
#
# --- make phiL[m] ---
#
    phiL = make_phi( nuL )
#
# --- calculate coefficients
#
#    print("## ----- calculate coef  -------")
    coefL = calc_coef( phiL, order_phaseLL, order_gainLL, gainL, psiL, turnL )
    sum2 = 0
    for i in range( len(coefL) ) :
        sum2 = sum2 + coefL[i]**2
#
# --- print coefficients 
    ntap = len( coefL )
    print("# ntap" )
    print( ntap )
    print("# %-15s  %-15s" % ( "coefficients", "turn") )
    for i in range( len(turnL) ):
        print(" %15.10g   %.5g" % ( coefL[i], turnL[i] ) )
    print("## power_pass = sum(coef^2) = ", sum2 )

def calc_coef( phiL, order_phaseLL, order_gainLL, gainL, psiL, turnL ) :

    def calc_fmu_gmu( phi, order_phaseLL, order_gainLL,gainL, psiL, turnL ) :
   
        def calc_nmu( phiL, order_phaseLL, order_gainLL ) :
            nmu = 0
            nnu = len( phiL )
            for m in range( nnu ) :
               print("##### order_gainLL[m]  m = ", order_gainLL[m], m ) 
               print("##### order_phaseLL[m] m = ", order_phaseLL[m], m ) 
               nmu += len( order_gainLL[m] ) 
               if phiL[m] != 0 :  # tune == 0 
                  nmu += len( order_phaseLL[m] )
            return nmu

        ntap = len( turnL ) 
        nnu  = len( phiL )
        nmu  = calc_nmu( phiL, order_phaseLL, order_gainLL )
        fmuLL = np.zeros( (nmu, ntap) )
        gmuL  = np.zeros( nmu )
        mu = 0 
        for m in range( nnu ) :
            if phiL[m] == 0 :  # tune == 0 
               for l in order_gainLL[m] :
                   for k in range( ntap ) :
                       fmuLL[mu,k] = turnL[k]**l 
                   if l == 0 :
                      print("## l gainL[m] = ",l, gainL[m])
                      gmuL[mu] = gainL[m] 
                      mu = mu+1
                   else:
                      gmuL[mu] = 0.0 
                      mu = mu+1
            else :  
               for l in order_gainLL[m]: 
                   if l == 0 :
                      for k in range( ntap ) :
                          fmuLL[mu,k] = np.cos( phiL[m] * turnL[k] )
                      gmuL[mu] = gainL[m] * np.cos( psiL[m] ) 
                      mu = mu+1
                      for k in range( ntap ) :
                          fmuLL[mu,k] = np.sin( phiL[m] * turnL[k] )
                      gmuL[mu] = gainL[m] * np.sin( psiL[m] ) 
                      mu = mu+1
                   else:
                      for k in range( ntap ) :
#                          fmuLL[mu,k] = turnL[k]**l * np.real( 1j**l * np.exp( -1j*( phiL[m]*turnL[k] + psiL[m] ) ) )  
#                          fmuLL[mu,k] = turnL[k]**l * np.real( 1j**l * np.exp( -1j*( phiL[m]*turnL[k] - psiL[m] ) ) )  
#                          fmuLL[mu,k] = turnL[k]**l * np.real( (-1j)**l * np.exp( -1j*( phiL[m]*turnL[k] + psiL[m] ) ) )  
                          fmuLL[mu,k] = turnL[k]**l * np.real( (-1j)**l * np.exp( 1j*( phiL[m]*turnL[k] - psiL[m] ) ) )  
                      gmuL[mu] = 0.0  # for derivative of Gain 8 dG/dphi )
                      mu = mu+1
               for l in order_phaseLL[m]:
                   if l != 0 :
                      for k in range( ntap ) :
#                          fmuLL[mu,k] = turnL[k]**l * np.imag( 1j**l * np.exp( -1j*( phiL[m]*turnL[k] + psiL[m] ) ) )  
#                          fmuLL[mu,k] = turnL[k]**l * np.imag( 1j**l * np.exp( -1j*( phiL[m]*turnL[k] - psiL[m] ) ) )  
#                          fmuLL[mu,k] = turnL[k]**l * np.imag( (-1j)**l * np.exp( -1j*( phiL[m]*turnL[k] + psiL[m] ) ) )  
                          fmuLL[mu,k] = turnL[k]**l * np.imag( (-1j)**l * np.exp( 1j*( phiL[m]*turnL[k] - psiL[m] ) ) )  
                      gmuL[mu] = 0.0 # for derivative of Phase ( dpsi/dphi ) 
                      mu = mu+1
        if mu != nmu :
            print("ERROR: mu != nmu : mu nmu = ", mu, nmu )  
        return fmuLL, gmuL, mu, nmu

    def calc_FF( fmuLL, mu ) :
        FFLL = np.zeros( ( mu,mu ),dtype=float)
        ntap = len( fmuLL[0,:] )
        for mu1 in range(mu) :
            for mu2 in range(mu) :
                FFLL[mu1,mu2] = 0
                for k in range(ntap) :
                    FFLL[mu1,mu2] = FFLL[mu1,mu2] + fmuLL[mu1,k] * fmuLL[mu2,k] 
        return FFLL
    fmuLL, gmuL, mu, nmu = calc_fmu_gmu( phiL, order_phaseLL, order_gainLL, gainL, psiL, turnL )
    FFLL = calc_FF( fmuLL, mu )
    detFF = np.linalg.det( FFLL ) 
    if detFF == 0 :
       print("ERROR : det(FF) = 0")
       quit()
    FFinvLL  = np.linalg.inv( FFLL ) 
    FFinvFLL = np.dot( FFinvLL, fmuLL )
    coefL = np.dot( gmuL, FFinvFLL )
    return coefL 

def make_phi( nuL ):
    nnu   = len( nuL )
    phiL = np.zeros( nnu )
    for m in range( nnu ) :
        phiL[m]  = -2*pi*nuL[m]
    return phiL

def dict2data( tuneL ) :
    nuL, gainL, psiL, order_phaseLL, order_gainLL = [], [], [], [], []
    for tune in tuneL :
        nu_m    = tune['nu']
        gain_m  = tune['gain']
        if nu_m == 0:
           order_phase_mL = [0]
        else:
           if 'order_phase' in tune.keys(): 
#               print("##A nu_m = ", nu_m )
               order_phase_m = tune['order_phase']
#               print("##----- tune  order_phase_m = ", tune, order_phase_m )
               order_phase_mL = [ i for i in range(order_phase_m+1) ] 
           elif 'order' in tune.keys():
#               print("##B nu_m = ", nu_m )
               order_phase_m = tune['order']
#               print("##----- tune  order_phase_m = ", tune, order_phase_m )
               order_phase_mL = [ i for i in range(order_phase_m+1) ] 
        if 'order_gain' in tune.keys():
           order_gain_m = tune['order_gain']
#           if is_scalar( order_gain_m ): 
           if np.isscalar( order_gain_m ): 
              order_gain_mL = [ i for i in range(order_gain_m+1) ]
           else:
              if 0 in order_gain_m:
                 order_gain_mL = order_gain_m  
              else:
                 order_gain_mL = order_gain_m
                 order_gain_mL.append(0)
#           print("##XX order_gain_mL = ", order_gain_mL )
        elif 'order' in tune.keys():
           order_gain_m  = tune['order']
           order_gain_mL = [ i for i in range(order_gain_m+1) ]
#           print("##YY order_gain_mL = ", order_gain_mL )
        else:
           print("ERROR: no order is defined") 

        if nu_m == 0 :
           psi_m  = 0
        else :
           if 'phase' in tune.keys(): 
              psi_m   = float( tune['phase'] )/180.*pi
           elif 'psi' in tune.keys(): 
              psi_m   = float( tune['psi'] )/180.*pi
           elif 'zeta' in tune.keys(): 
              psi_m   = float( tune['zeta'] )/180.*pi
           else:
              print("ERROR: no phase is defined for tune = ", tune )
        if nu_m != 0 :
           if len(order_gain_mL) != 0 :
              if order_phase_m < max( order_gain_mL ) :
                 print("ERROR in tune : order_gain <= order_pase : tune max(order_gain) order_phase = ", nu_m, max(order_gain_mL), order_phase_m ) 
#        print("## nu_m order_phase_mL = ", nu_m, order_phase_mL )
#        print("## nu_m order_gain_mL  = ", nu_m, order_gain_mL )
        nuL.append( nu_m )
        gainL.append( gain_m )
        psiL.append( psi_m )
        order_phaseLL.append( order_phase_mL )
        order_gainLL.append( order_gain_mL )
#        print("##00-- tune order_phase_mL = ", tune, order_phase_mL )
#        print("##00-- tune order_gain_mL  = ", tune, order_gain_mL )
    return nuL, gainL, psiL, order_phaseLL, order_gainLL

if __name__ == '__main__' :
#    main( in_put.tuneL, in_put.turnL )
    print("# filename = ", filename )
    main( filename )



#  Tue Apr 23 13:40:18 JST 2024


#  Fri Nov 15 10:44:05 JST 2024
#  /Users/nakamura/Dropbox/FIR/FIR_tools/coef/python/v5/example
#


#  Thu Jan 15 19:01:07 JST 2026
#  /Users/nakamura/Dropbox/Feedback/MR/FIR/H_0.3-0.4_26Jan17/two-sets/data
#


#  Mon Jan 19 16:30:04 JST 2026
#  /Users/nakamura/Dropbox/Feedback/MR/FIR/H_0.39_26Jan17/one-FIR/one-FIR
#
